<?php
header("Content-Type: application/json");
require_once "db_connect.php";

$response = ["success" => false, "message" => "Invalid request"];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $staff_id = intval($_POST['staff_id'] ?? 0);
    $otp_code = trim($_POST['otp_code'] ?? "");

    if ($staff_id <= 0 || $otp_code === "") {
        echo json_encode([
            "success" => false,
            "message" => "Missing staff_id or otp_code"
        ]);
        exit;
    }

    // Fetch the latest OTP for this staff
    $stmt = $con->prepare("SELECT id, otp_code, expires_at 
                           FROM otp_codes 
                           WHERE staff_id = ? 
                           ORDER BY id DESC 
                           LIMIT 1");
    if (!$stmt) {
        echo json_encode([
            "success" => false,
            "message" => "Database error: " . $con->error
        ]);
        exit;
    }

    $stmt->bind_param("i", $staff_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        $db_code = $row['otp_code'];
        $expires_at = strtotime($row['expires_at']);
        $now = time();

        if ($now > $expires_at) {
            $response = ["success" => false, "message" => "OTP expired"];
        } elseif ($otp_code === $db_code) {
            $response = ["success" => true, "message" => "OTP verified"];
            
            // optional: delete OTP after use
            $del = $con->prepare("DELETE FROM otp_codes WHERE id = ?");
            $del->bind_param("i", $row['id']);
            $del->execute();
            $del->close();
        } else {
            $response = ["success" => false, "message" => "Invalid OTP"];
        }
    } else {
        $response = ["success" => false, "message" => "No OTP found for this user"];
    }

    $stmt->close();
}

echo json_encode($response);
$con->close();
?>
