<?php
header("Content-Type: application/json");
require_once "db_connect.php"; // Your DB connection file

// Include ZKTeco PHP SDK (adjust path)
require_once "zk_fp_sdk.php"; // e.g., ZKFinger PHP SDK wrapper

// Get POST data
$staff_token = $_POST['staff_token'] ?? '';
$fingerprint_template = $_POST['fingerprint_template'] ?? '';
$lat = $_POST['lat'] ?? '';
$lng = $_POST['lng'] ?? '';

if (!$staff_token || !$fingerprint_template) {
    echo json_encode([
        "status" => "error",
        "message" => "Missing required parameters"
    ]);
    exit;
}

// Decode template from Base64
$scannedTemplate = base64_decode($fingerprint_template);

// Fetch enrolled templates for this staff
$stmt = $conn->prepare("SELECT fingerprint_template FROM fingerprints WHERE staff_token = ?");
$stmt->bind_param("s", $staff_token);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 0) {
    echo json_encode([
        "status" => "error",
        "message" => "No enrolled fingerprints for this staff"
    ]);
    exit;
}

// Initialize SDK matcher
$zk = new ZKFingerprintSDK(); // Your SDK initialization
$matched = false;

while ($row = $result->fetch_assoc()) {
    $storedTemplate = base64_decode($row['fingerprint_template']);

    // Use SDK matching function
    if ($zk->match($scannedTemplate, $storedTemplate)) {
        $matched = true;
        break;
    }
}

if ($matched) {
    // Record attendance
    $stmtInsert = $conn->prepare("INSERT INTO attendance (staff_token, lat, lng, attendance_time) VALUES (?, ?, ?, NOW())");
    $stmtInsert->bind_param("sdd", $staff_token, $lat, $lng);
    $stmtInsert->execute();

    echo json_encode([
        "status" => "success",
        "message" => "Fingerprint verified and attendance recorded"
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Fingerprint did not match"
    ]);
}

// Close statements
$stmt->close();
if (isset($stmtInsert)) $stmtInsert->close();
$conn->close();
?>
