<?php
// ✅ Show errors for debugging (remove on production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

include "db_connect.php"; // must define $con = new mysqli(...);

$message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $site_name = $_POST['site_name'] ?? '';
    $latitude  = $_POST['latitude'] ?? '';
    $longitude = $_POST['longitude'] ?? '';
    $radius    = $_POST['radius'] ?? '';
    $site_token = bin2hex(random_bytes(8)); // unique site token

    if (!empty($site_name) && !empty($latitude) && !empty($longitude) && !empty($radius)) {
        $sql = "INSERT INTO sites (site_name, latitude, longitude, radius, site_token, created_at)
                VALUES (?, ?, ?, ?, ?, NOW())";
        $stmt = $con->prepare($sql);
        if ($stmt === false) {
            die("❌ Prepare failed: " . $con->error);
        }

        // ⚡ Fixed type binding: s = string, d = double, i = integer
        $stmt->bind_param("sddis", $site_name, $latitude, $longitude, $radius, $site_token);

        if ($stmt->execute()) {
            $message = "✅ Site added successfully!<br>🔑 Token: <b>" . htmlspecialchars($site_token) . "</b>";
        } else {
            $message = "❌ Database error: " . $stmt->error;
        }
        $stmt->close();
    } else {
        $message = "⚠️ Please fill all fields";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Add Site</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f8f9fa; padding: 30px; }
        .container { max-width: 500px; margin: auto; background: #fff; padding: 20px; border-radius: 10px; box-shadow: 0 0 8px #ccc; }
        h2 { text-align: center; color: #1da1f2; }
        input, button { width: 100%; padding: 10px; margin: 8px 0; border-radius: 6px; border: 1px solid #ccc; }
        button { background: #1da1f2; color: #fff; border: none; cursor: pointer; }
        button:hover { background: #0d8ddb; }
        .msg { text-align: center; margin: 10px 0; font-weight: bold; }
        .success { color: green; }
        .error { color: red; }
    </style>
    <script>
        function getLocation() {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function(position) {
                    document.getElementById("latitude").value = position.coords.latitude;
                    document.getElementById("longitude").value = position.coords.longitude;
                }, function(error) {
                    alert("Error getting location: " + error.message);
                });
            } else {
                alert("Geolocation is not supported by this browser.");
            }
        }
        window.onload = getLocation;
    </script>
</head>
<body>
    <div class="container">
        <h2>Register New Site</h2>
        <?php if ($message): ?>
            <div class="msg <?= (strpos($message, '✅') !== false) ? 'success' : 'error' ?>">
                <?= $message ?>
            </div>
        <?php endif; ?>
        <form method="POST">
            <input type="text" name="site_name" placeholder="Site Name" required>
            <input type="number" step="any" id="latitude" name="latitude" placeholder="Latitude" required>
            <input type="number" step="any" id="longitude" name="longitude" placeholder="Longitude" required>
            <input type="number" name="radius" placeholder="Radius (meters)" required>
            <button type="submit">Save Site</button>
        </form>
    </div>
</body>
</html>
