<?php
header("Content-Type: application/json");
require_once "db_connect.php";

$staff_token = $_POST['staff_token'] ?? '';
$fingerprint_template = $_POST['fingerprint_template'] ?? '';

if (!$staff_token || !$fingerprint_template) {
    echo json_encode(["status" => "error", "message" => "Missing parameters"]);
    exit;
}

$stmt = $conn->prepare("INSERT INTO fingerprints (staff_token, fingerprint_template) VALUES (?, ?)");
$stmt->bind_param("ss", $staff_token, $fingerprint_template);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "Fingerprint saved"]);
} else {
    echo json_encode(["status" => "error", "message" => $conn->error]);
}

$stmt->close();
$conn->close();
?>
