<?php
require_once "db_connect.php"; // your DB connection
require_once "config.php"; // your DB connection

// Force MySQLi to throw errors
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// Fetch all staff with QR codes
$sql = "SELECT fullname, department, email, staff_token, qr_code FROM staff ORDER BY fullname ASC";
$result = $conn->query($sql);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>QR Code Viewer</title>
<style>
    body {
        font-family: "Segoe UI", Arial, sans-serif;
        background: #f7f7f7;
        margin: 20px;
    }
    h2 {
        text-align: center;
        margin-bottom: 20px;
        color: #222;
    }
    .grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
        gap: 20px;
    }
    .card {
        background: #fff;
        border: 1px solid #ddd;
        padding: 10px;
        text-align: center;
        border-radius: 10px;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        transition: transform 0.2s;
    }
    .card:hover {
        transform: scale(1.03);
    }
    .qr-thumb {
        width: 100px;
        height: 100px;
        object-fit: contain;
        cursor: pointer;
        border-radius: 5px;
        transition: 0.3s;
    }
    .qr-thumb:hover {
        opacity: 0.8;
    }
    .info {
        margin-top: 10px;
        font-size: 14px;
    }
    /* Fullscreen QR overlay */
    .overlay {
        display: none;
        position: fixed;
        z-index: 9999;
        left: 0; top: 0;
        width: 100%; height: 100%;
        background-color: rgba(0, 0, 0, 0.8);
        justify-content: center;
        align-items: center;
    }
    .overlay img {
        width: 300px;
        height: 300px;
        object-fit: contain;
        border: 5px solid #fff;
        border-radius: 10px;
        box-shadow: 0 0 20px rgba(255,255,255,0.3);
    }
    .overlay:target {
        display: flex;
    }
    .close-btn {
        position: absolute;
        top: 20px;
        right: 30px;
        color: #fff;
        font-size: 30px;
        text-decoration: none;
        font-weight: bold;
    }
</style>
</head>
<body>

<h2>Staff QR Code Viewer</h2>

<div class="grid">
<?php
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $name = htmlspecialchars($row['fullname']);
        $dept = htmlspecialchars($row['department']);
        $email = htmlspecialchars($row['email']);
        $token = htmlspecialchars($row['staff_token']);
        $qr = htmlspecialchars($row['qr_code']);

        // Ensure QR path is valid relative URL
        $qrDisplay = "qrcodes/" . basename($qr);
        $overlayId = "qr_" . md5($token);

        echo "
        <div class='card'>
            <img src='$qrDisplay' alt='QR for $name' class='qr-thumb' onclick=\"openOverlay('$qrDisplay')\">
            <div class='info'>
                <strong>$name</strong><br>
                <small>$dept</small><br>
                <small>$email</small>
            </div>
        </div>
        ";
    }
} else {
    echo "<p style='text-align:center;'>No staff QR codes found.</p>";
}
$conn->close();
?>
</div>

<!-- Overlay modal -->
<div id="qrOverlay" class="overlay" onclick="closeOverlay()">
    <a href="#" class="close-btn" onclick="closeOverlay()">×</a>
    <img id="overlayImg" src="" alt="Expanded QR Code">
</div>

<script>
function openOverlay(imgSrc) {
    document.getElementById('overlayImg').src = imgSrc;
    document.getElementById('qrOverlay').style.display = 'flex';
}
function closeOverlay() {
    document.getElementById('qrOverlay').style.display = 'none';
}
</script>

</body>
</html>
