<?php
header("Content-Type: application/json");
require_once "db_connect.php";  // adjust path if needed

$response = ["success" => false, "message" => "Invalid request"];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? "");
    $password = trim($_POST['password'] ?? "");

    if ($username === "" || $password === "") {
        echo json_encode([
            "success" => false,
            "message" => "Username and password required"
        ]);
        exit;
    }

    // ✅ Create OTP table if it does not exist
    $createTableQuery = "
        CREATE TABLE IF NOT EXISTS otp_codes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    staff_id INT NULL,
    staff_token VARCHAR(100) NOT NULL,
    otp_code VARCHAR(6) NOT NULL,
    expires_at DATETIME NOT NULL,
    INDEX (staff_id),
    FOREIGN KEY (staff_id) REFERENCES staff(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

    ";
    if (!$con->query($createTableQuery)) {
        echo json_encode([
            "success" => false,
            "message" => "Failed to ensure OTP table: " . $con->error
        ]);
        exit;
    }

    // check staff record
    $stmt = $con->prepare("SELECT id, username, password, staff_token, role, site_token 
                           FROM staff 
                           WHERE username = ? 
                           LIMIT 1");
    if (!$stmt) {
        echo json_encode([
            "success" => false,
            "message" => "Database error: " . $con->error
        ]);
        exit;
    }

    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        // verify password (plain or hashed)
        if (password_verify($password, $row['password']) || $password === $row['password']) {
            
            // ✅ restrict login to supervisors only
            if (strtolower($row['role']) !== "supervisor") {
                echo json_encode([
                    "success" => false,
                    "message" => "Only supervisors can log in"
                ]);
                exit;
            }

            // ✅ Generate OTP
            $otp = rand(100000, 999999);
            $expiry = date("Y-m-d H:i:s", strtotime("+5 minutes"));

            // Delete old OTP for this staff
            $delStmt = $con->prepare("DELETE FROM otp_codes WHERE staff_id = ?");
            $delStmt->bind_param("i", $row['id']);
            $delStmt->execute();

            // Insert new OTP
            $insertStmt = $con->prepare("INSERT INTO otp_codes (staff_id, otp_code, expires_at) VALUES (?, ?, ?)");
            $insertStmt->bind_param("sss", $row['staff_id'], $otp, $expiry);
            $insertStmt->execute();

            // ✅ success
            $response = [
                "success"   => true,
                "message"   => "Login successful. OTP generated.",
                "staff_token"  => $row['staff_token'],
                "role"      => $row['role'],
                "site_token"=> $row['site_token'],
                "otp"       => $otp // ⚠️ Testing only, don’t expose in production
            ];
        } else {
            $response = ["success" => false, "message" => "Invalid password"];
        }
    } else {
        $response = ["success" => false, "message" => "User not found"];
    }

    $stmt->close();
}

echo json_encode($response);
$con->close();
