<?php
require_once "config.php";
require_once "db_connect.php";
header("Content-Type: application/json");

// Debugging temporarily (optional)
ini_set('display_errors', 0);
error_reporting(0);

if (!$conn) {
    echo json_encode(["status" => "error", "message" => "Database connection failed"]);
    exit;
}

$device_id = $_GET['device_id'] ?? '';
$ssid = $_GET['ssid'] ?? '';

if (empty($device_id)) {
    echo json_encode(["status" => "error", "message" => "Missing device ID"]);
    exit;
}

// Ensure table exists
$conn->query("CREATE TABLE IF NOT EXISTS staff_devices (
    id INT AUTO_INCREMENT PRIMARY KEY,
    staff_token VARCHAR(64) NOT NULL,
    device_id VARCHAR(255) NOT NULL UNIQUE,
    ssid VARCHAR(255) DEFAULT NULL,
    device_name VARCHAR(255) DEFAULT NULL,
    registered_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

// Check if device is registered
$stmt = $conn->prepare("SELECT staff_token FROM staff_devices WHERE device_id = ?");
$stmt->bind_param("s", $device_id);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    // ✅ Registered
    echo json_encode([
        "status" => "registered",
        "staff_token" => $row['staff_token'],
        "message" => "Device recognized"
    ]);
} else {
    // ❌ Not registered
    echo json_encode([
        "status" => "not_registered",
        "message" => "Device not registered"
    ]);
}

$stmt->close();
$conn->close();
