 <?php
include 'config.php';

// 📌 Read parameters
$staff_token = $_GET['staff_token'] ?? '';
$attendance_token = $_GET['attendance_token'] ?? '';
$expected_lat = $_GET['lat'] ?? '';
$expected_lng = $_GET['lng'] ?? '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $staff_token = $_POST['staff_token'] ?? '';
    $attendance_token = $_POST['attendance_token'] ?? '';
    $latitude = $_POST['latitude'] ?? '';
    $longitude = $_POST['longitude'] ?? '';
    $selfie = $_POST['selfie'] ?? '';

    if (!$staff_token || !$attendance_token || !$latitude || !$longitude || !$selfie) {
        die("Missing required data");
    }

    // 🟩 Create selfie folder
    $folderPath = "selfies/";
    if (!is_dir($folderPath)) {
        mkdir($folderPath, 0777, true);
    }

    // 🟩 Save selfie image
    $image_parts = explode(";base64,", $selfie);
    $image_base64 = base64_decode($image_parts[1]);
    $fileName = $staff_token . "_" . time() . ".jpg";
    $file = $folderPath . $fileName;
    file_put_contents($file, $image_base64);

    // 🟩 Insert new confirmation record
    $stmt = $conn->prepare("
        INSERT INTO attendance_confirmations 
        (attendance_token, staff_token, latitude, longitude, selfie_path) 
        VALUES (?, ?, ?, ?, ?)
    ");
    $stmt->bind_param("ssdds", $attendance_token, $staff_token, $latitude, $longitude, $file);
    $stmt->execute();

    if ($stmt->affected_rows > 0) {
        echo "<script>alert('✅ Attendance confirmation submitted successfully!');window.location.href='admin_attendance.php';</script>";
    } else {
        echo "<script>alert('⚠️ Failed to save confirmation. Try again.');window.history.back();</script>";
    }
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Confirm Attendance</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {
      font-family: Arial, sans-serif;
      text-align: center;
      padding: 10px;
      background: #f7f9fb;
    }
    h3 { color: #1da1f2; }
    video, canvas {
      width: 90%;
      max-width: 350px;
      border-radius: 10px;
      margin-top: 10px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.15);
    }
    button {
      background: #1da1f2;
      color: #fff;
      padding: 10px 18px;
      border: none;
      border-radius: 6px;
      margin-top: 12px;
      font-size: 16px;
    }
    #submitBtn { background: #28a745; }
  </style>
</head>
<body>
  <h3>Confirm Your Attendance</h3>
  <p>Take a live selfie and verify your location.</p>

  <video id="video" autoplay playsinline></video>
  <canvas id="canvas" style="display:none;"></canvas>

  <form id="selfieForm" method="POST">
      <input type="hidden" name="staff_token" value="<?= htmlspecialchars($staff_token) ?>">
      <input type="hidden" name="attendance_token" value="<?= htmlspecialchars($attendance_token) ?>">
      <input type="hidden" name="latitude" id="latitude">
      <input type="hidden" name="longitude" id="longitude">
      <input type="hidden" name="selfie" id="selfie">
      <br>
      <button type="button" id="captureBtn">📸 Capture Selfie</button>
      <button type="submit" id="submitBtn" style="display:none;">✅ Submit Confirmation</button>
  </form>

  <script>
    const expectedLat = parseFloat("<?= $expected_lat ?>");
    const expectedLng = parseFloat("<?= $expected_lng ?>");
    const maxDistance = 0.1; // 100 meters allowed range

    const video = document.getElementById('video');
    const canvas = document.getElementById('canvas');
    const captureBtn = document.getElementById('captureBtn');
    const submitBtn = document.getElementById('submitBtn');

    // ✅ Start camera safely
    async function startCamera() {
      try {
        const stream = await navigator.mediaDevices.getUserMedia({ video: { facingMode: "user" } });
        video.srcObject = stream;
      } catch (err) {
        alert("⚠️ Camera access denied. Please allow camera permission.");
      }
    }

    // ✅ Get GPS
    function getLocation() {
      if (!navigator.geolocation) {
        alert("Geolocation not supported.");
        return;
      }
      navigator.geolocation.getCurrentPosition(
        position => {
          const lat = position.coords.latitude;
          const lng = position.coords.longitude;
          document.getElementById('latitude').value = lat;
          document.getElementById('longitude').value = lng;

          const dist = getDistance(lat, lng, expectedLat, expectedLng);
          if (dist > maxDistance) {
            alert("⚠️ You are not within your site area (" + dist.toFixed(2) + "km away).");
            captureBtn.disabled = true;
          }
        },
        err => {
          alert("⚠️ Please allow location access.");
        },
        { enableHighAccuracy: true, timeout: 10000 }
      );
    }

    // ✅ Distance calc
    function getDistance(lat1, lon1, lat2, lon2) {
      const R = 6371;
      const dLat = (lat2 - lat1) * Math.PI / 180;
      const dLon = (lon2 - lon1) * Math.PI / 180;
      const a = Math.sin(dLat / 2) ** 2 +
                Math.cos(lat1 * Math.PI / 180) * Math.cos(lat2 * Math.PI / 180) *
                Math.sin(dLon / 2) ** 2;
      const c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
      return R * c;
    }

    // ✅ Capture selfie
    captureBtn.onclick = () => {
      const ctx = canvas.getContext('2d');
      canvas.width = video.videoWidth;
      canvas.height = video.videoHeight;
      ctx.drawImage(video, 0, 0, canvas.width, canvas.height);
      const dataURL = canvas.toDataURL('image/jpeg');
      document.getElementById('selfie').value = dataURL;

      video.style.display = 'none';
      canvas.style.display = 'block';
      captureBtn.style.display = 'none';
      submitBtn.style.display = 'inline-block';
    };

    // ✅ Initialize
    startCamera();
    getLocation();
  </script>
</body>
</html>