<?php
require_once "db_connect.php"; // your database connection
require_once "phpqrcode/qrlib.php"; // include QR library

// Force MySQLi to throw errors for debugging
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fullname   = trim($_POST['fullname'] ?? "");
    $email      = trim($_POST['email'] ?? "");
    $department = trim($_POST['department'] ?? "");
    $username   = trim($_POST['username'] ?? "");
    $password   = trim($_POST['password'] ?? "");

    if ($fullname === "" || $email === "" || $username === "" || $password === "") {
        die("Fullname, Email, Username and Password are required.");
    }

    // ✅ Make sure your DB variable matches what you set in db_connect.php
    // If you use $conn there, replace $con with $conn below
    $db = $con ?? $conn;

    // Check if username already exists
    $check = $db->prepare("SELECT id FROM staff WHERE username = ?");
    $check->bind_param("s", $username);
    $check->execute();
    $exists = $check->get_result();
    if ($exists->num_rows > 0) {
        die("Error: Username already exists.");
    }
    $check->close();

    // generate unique staff token
    $staff_token = bin2hex(random_bytes(8));

    // create folder for QR codes
    $qrDir = __DIR__ . "/qrcodes/";
    if (!is_dir($qrDir)) {
        mkdir($qrDir, 0777, true);
    }

    // generate QR code image
    $qrFile = $qrDir . $staff_token . ".png";
    QRcode::png($staff_token, $qrFile, QR_ECLEVEL_L, 5);

    // hash password
    $hashedPassword = password_hash($password, PASSWORD_BCRYPT);

    // save staff to database
    $stmt = $db->prepare("INSERT INTO staff (staff_token, fullname, email, department, username, password, qr_code) VALUES (?,?,?,?,?,?,?)");
    $stmt->bind_param("sssssss", $staff_token, $fullname, $email, $department, $username, $hashedPassword, $qrFile);

    if ($stmt->execute()) {
        echo "<h3>Staff Added Successfully!</h3>";
        echo "<p><b>Name:</b> $fullname</p>";
        echo "<p><b>Email:</b> $email</p>";
        echo "<p><b>Department:</b> $department</p>";
        echo "<p><b>Username:</b> $username</p>";
        echo "<p><b>Staff Token:</b> $staff_token</p>";
        echo "<p><img src='qrcodes/" . basename($qrFile) . "' alt='QR Code'></p>";
    } else {
        echo "Error: " . $stmt->error;
    }
    $stmt->close();
    $db->close();
}
?>
